import { View, Text, FlatList, TouchableOpacity } from "react-native";
import { useDispatch, useSelector } from "react-redux";
import BackNavigation from "../../Utilities/CustomHeader/BackNavigation";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { orderHistoryStyle } from "../OrderHistory/OrderHistoryStyle";
import { ProfileStyles } from "../ProfileStyle";
import { myReviresStyle } from "./MyReviewsStyle";
import DotIcon from "../../../assets/svgs/order history/dot.svg";
import DownIcon from "../../../assets/svgs/dropdown/down.svg";
import UpIcon from "../../../assets/svgs/dropdown/up.svg";
import EditIcon from "../../../assets/svgs/profile/edit profile.svg";
import { useEffect, useState } from "react";
import useAuth from "../../../hooks/useAuth";
import {
    fetchReviewStart,
    getMoreReviews,
    getMyReviews,
    getMyReviewsSuccree,
} from "../../../redux/slices/user/myReviews/getMyReviews";
import { refresh } from "../../../redux/slices/user/util/refresh";
import OrderHistorySkeleton from "../../../src/skeletons/screens/profile/order/OrderHistorySkeleton";
import EmptyContent from "../../Utilities/EmptyContent/EmptyContent";
import NoContentIcon from "../../../assets/svgs/empty content/noAddress.svg";
import { useRef } from "react";
import ProgressiveImage from "../../../src/components/ProgressiveImage";
import { BASE_API_URL_STG } from "@env";
import CustomRating from "../../Utilities/CustomRating/CustomRating";
import { round } from "../../../helper/ratingRound";
import CustomActiveIndicator from "../../../src/components/CustomLoader/CustomActiveIndicator";
import { useMemo } from "react";
import SelectInput from "../../../src/components/CustomInput/SelectInput/SelectInput";
import DownArrowFill from "../../../assets/svgs/downArrowFill.svg";
import SelectItemBottomSheet from "../../../src/components/SelectItemBottomSheet/SelectItemBottomSheet";
import useLangTranslation from "../../../hooks/useLangTranslation";
import { txtSliceFmt } from "../../../helper/txtSliceFmt";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const dotSize = dpr(6);
const dateFilter = [
    { name: "All Time", value: "" },
    { name: "Today", value: "today" },
    { name: "Last 7 days", value: "last_week" },
    { name: "Last 30 Days", value: "last_month" },
    { name: "Last 12 Month", value: "last_year" },
];
const statusFilter = [
    { name: "All Status", value: "" },
    { name: "Approve", value: "active" },
    { name: "Unapproved", value: "inactive" },
];

const URL = `${BASE_API_URL_STG}/user/reviews`;

const MyReviews = (props) => {
    const { trans } = useLangTranslation();
    const dispatch = useDispatch();
    const { access_token } = useAuth();
    const { myReviews, isRefresh, nextPageUrl, loadMore } = useSelector(
        (state) => state.getMyReviewsSlice
    );
    const [showDetails, setShowDetails] = useState({
        id: null,
        show: false,
    });

    const dateRef = useRef(null);
    const statusRef = useRef(null);
    const [date, setDate] = useState(null);
    const [status, setStatus] = useState(null);
    const [inFileLoading, setInFileLoading] = useState(true);
    const [url, setUrl] = useState(URL);
    useEffect(() => {
        (async () => {
            setInFileLoading(true);
            if (date?.value && status?.value) {
                let url = `${URL}?filter=${date?.value}&status=${status?.value}`;
                setUrl(url);
                await dispatch(getMyReviews({ access_token, URL: url }));
            } else if (date?.value && !status?.value) {
                let url = `${URL}?filter=${date?.value}`;
                setUrl(url);
                await dispatch(getMyReviews({ access_token, URL: url }));
            } else if (!date?.value && status?.value) {
                let url = `${URL}?status=${status?.value}`;
                setUrl(url);
                await dispatch(getMyReviews({ access_token, URL: url }));
            } else {
                await dispatch(getMyReviews({ access_token, URL }));
            }
            setInFileLoading(false);
        })()
    }, [date, status]);

    const handleShowDetails = (id) => {
        setShowDetails({
            id: id,
            show: true,
        });
    };
    const handleHideDetails = (id) => {
        setShowDetails({
            id: id,
            show: false,
        });
    };

    const onRefresh = () => {
        setDate(null);
        setStatus(null);
        refresh(
            access_token,
            URL,
            dispatch,
            fetchReviewStart,
            getMyReviewsSuccree
        );
    };

    const handleLoadMoreReviews = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getMoreReviews({ access_token, URL: nextPageUrl }));
        }
        return () => {
            isMounted = false;
        };
    };

    const memoizeReview = useMemo(
        () =>
            ({ item }) =>
                <RenderItem item={item} />,
        [showDetails]
    );

    const RenderItem = ({ item }) => {
        return (
            <View style={orderHistoryStyle.item}>
                <View style={orderHistoryStyle.header}>
                    <Text
                        style={orderHistoryStyle.headerText}
                        numberOfLines={2}
                    >
                        {item?.product_name}
                    </Text>

                    <CustomRating
                        rating={round(item?.rating)}
                        starSize={dpr(18)}
                        readOnly={true}
                    />
                </View>
                <View style={myReviresStyle.detailsCont}>
                    <View style={orderHistoryStyle.info}>
                        <View style={orderHistoryStyle.infoTextCont}>
                            <CustomSVG svgIcon={DotIcon}
                                height={dotSize}
                                width={dotSize}
                                fill={"#C4C4C4"}
                            />
                            <Text style={orderHistoryStyle.infoText}>
                                {item?.created_at}
                            </Text>
                        </View>
                        <View style={orderHistoryStyle.infoTextCont}>
                            <CustomSVG svgIcon={DotIcon}
                                height={dotSize}
                                width={dotSize}
                                fill={"#C4C4C4"}
                            />
                            <Text style={orderHistoryStyle.infoText}>
                                {item.rating} {trans("Stars")}
                            </Text>
                        </View>
                        <View style={orderHistoryStyle.infoTextCont}>
                            <CustomSVG svgIcon={DotIcon}
                                height={dotSize}
                                width={dotSize}
                                fill={"#C4C4C4"}
                            />
                            <Text style={orderHistoryStyle.infoText}>
                                {trans(item.status)}
                            </Text>
                        </View>
                    </View>
                    <View>
                        {showDetails.id == item.id && showDetails.show ? (
                            <TouchableOpacity
                                onPress={() => handleHideDetails(item.id)}
                                style={myReviresStyle.dropDown}
                            >
                                <CustomSVG svgIcon={UpIcon} fill={"#2C2C2C"} />
                            </TouchableOpacity>
                        ) : (
                            <TouchableOpacity
                                onPress={() => handleShowDetails(item.id)}
                                style={myReviresStyle.dropDown}
                            >
                                <CustomSVG svgIcon={DownIcon} fill={"#898989"} />
                            </TouchableOpacity>
                        )}
                    </View>
                </View>
                {showDetails.id == item.id && showDetails.show && (
                    <View>
                        <Text style={myReviresStyle.detailsTitle}>
                            {trans("Review you wrote")}
                        </Text>
                        <Text style={myReviresStyle.detailsText}>
                            {item.comments}
                        </Text>
                        <View style={myReviresStyle.detailsImgCont}>
                            <View style={myReviresStyle.detailsImg}>
                                {item?.image?.length > 0 &&
                                    item?.image
                                        ?.slice(0, 4)
                                        .map((img, index) => (
                                            <ProgressiveImage
                                                key={index}
                                                source={{ uri: img }}
                                                style={
                                                    myReviresStyle.detailsSingleImg
                                                }
                                            />
                                        ))}
                                {item?.image?.length > 4 && (
                                    <TouchableOpacity
                                        style={myReviresStyle.layerImg}
                                        onPress={() =>
                                            props.navigation.navigate(
                                                "Edit Review",
                                                {
                                                    item,
                                                    url,
                                                }
                                            )
                                        }
                                        hitSlop={6}
                                    >
                                        <View>
                                            <Text
                                                style={
                                                    myReviresStyle.layerImgText
                                                }
                                            >
                                                +{item?.image.length - 3}
                                            </Text>
                                        </View>
                                    </TouchableOpacity>
                                )}
                            </View>
                            <TouchableOpacity
                                onPress={() =>
                                    props.navigation.navigate("Edit Review", {
                                        item,
                                        url,
                                    })
                                }
                                hitSlop={6}
                            >
                                <View style={myReviresStyle.editReviewCont}>
                                    <CustomSVG svgIcon={EditIcon}
                                        height={dpr(12)}
                                        width={dpr(12)}
                                    />
                                    <Text style={myReviresStyle.editText}>
                                        {trans("Edit Review")}
                                    </Text>
                                </View>
                            </TouchableOpacity>
                        </View>
                    </View>
                )}
            </View>
        );
    };

    const [loadBtmSheet, setLoadBtmSheet] = useState(false);
    useEffect(() => {
        setLoadBtmSheet(true);
    }, []);

    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans("my reviews")}
                capitalize={false}
            />
            <View style={ProfileStyles.hrLine} />
            <View style={myReviresStyle.container}>
                <View style={orderHistoryStyle.filterCont}>
                    <Text style={orderHistoryStyle.filterText}>
                        {txtSliceFmt(trans("Filter By"), 10)}
                    </Text>
                    <SelectInput
                        style={orderHistoryStyle.orderSelectInputCont}
                        placeholder={trans("All Time")}
                        onPress={() => dateRef.current?.snapToIndex(0)}
                        title={trans(date?.name)}
                        icon={<CustomSVG svgIcon={DownArrowFill} fill={"#2C2C2C"} />}
                    />
                    <SelectInput
                        style={orderHistoryStyle.orderSelectInputCont}
                        placeholder={trans("All Status")}
                        onPress={() => statusRef.current?.snapToIndex(0)}
                        title={trans(status?.name)}
                        icon={<CustomSVG svgIcon={DownArrowFill} fill={"#2C2C2C"} />}
                    />
                </View>
                {inFileLoading ? (
                    <OrderHistorySkeleton />
                ) : (
                    <>
                        {myReviews?.length > 0 ? (
                            <FlatList
                                data={myReviews}
                                keyExtractor={(_, i) => "key-A" + i}
                                renderItem={memoizeReview}
                                refreshing={isRefresh}
                                onRefresh={onRefresh}
                                showsVerticalScrollIndicator={false}
                                initialNumToRender={10}
                                windowSize={10}
                                onEndReachedThreshold={1}
                                onEndReached={handleLoadMoreReviews}
                            />
                        ) : (
                            <FlatList
                                style={myReviresStyle.flatList}
                                keyExtractor={(_, i) => "key-A" + i}
                                refreshing={isRefresh}
                                onRefresh={onRefresh}
                                showsVerticalScrollIndicator={false}
                                ListHeaderComponent={() => (
                                    <EmptyContent
                                        Icon={NoContentIcon}
                                        text={trans("No Reviews Given")}
                                    />
                                )}
                            />
                        )}
                    </>
                )}
            </View>
            {loadMore && <CustomActiveIndicator />}
            {loadBtmSheet && (
                <>
                    <SelectItemBottomSheet
                        snapPoint={[300]}
                        selectRef={dateRef}
                        data={dateFilter}
                        name={"Time"}
                        onPress={setDate}
                    />
                    <SelectItemBottomSheet
                        snapPoint={[300]}
                        selectRef={statusRef}
                        data={statusFilter}
                        name={"Status"}
                        onPress={setStatus}
                    />
                </>
            )}
        </>
    );
};

export default MyReviews;
